<?php
// index.php (ADEX) — Painel inicial em cards

// ✅ Produção: deixe isso desligado.
// (se precisar depurar, troque para 1 temporariamente)
ini_set('display_errors', 0);
ini_set('display_startup_errors', 0);
error_reporting(E_ALL);

// Caminho absoluto para os includes públicos (DB do site principal)
$includes_path = '/home/tomverascom/public_html/artistas-de-blues/includes/';

// Config do subdomínio ADEX (apenas se constantes não existirem)
if (!defined('DB_HOST')) {
  include_once(__DIR__ . '/includes_adex/config.php');
}

// DB do site principal (mantém padrão do seu sistema; pode ser útil para contadores no futuro)
include_once($includes_path . 'db_connect.php');

// Template ADEX
include_once(__DIR__ . '/includes_adex/header.php');
include_once(__DIR__ . '/includes_adex/menu_adex.php');
?>

<div class="container my-4 my-lg-5">

  <div class="d-flex flex-column flex-lg-row justify-content-between align-items-start gap-2 mb-4">
    <div>
      <h1 class="h3 mb-1">Painel ADEX</h1>
      <div class="text-muted">Atalhos do sistema (cadastro, edição e listagens).</div>
    </div>
  </div>

  <div class="row g-3 g-lg-4">

    <!-- Instagram -->
    <div class="col-12 col-lg-4">
      <div class="card h-100 shadow-sm border-0">
        <div class="card-body">
          <div class="d-flex align-items-center justify-content-between mb-2">
            <h2 class="h5 mb-0">Instagram</h2>
            <span class="badge bg-dark">Posts</span>
          </div>

          <p class="text-muted mb-3" style="max-width: 52ch;">
            Publicação e gerenciamento de posts que entram no seu fluxo de conteúdo.
          </p>

          <div class="d-grid gap-2">
            <a class="btn btn-dark" href="/pages_adex/inserir_instagram.php">Inserir Post</a>
            <a class="btn btn-outline-dark" href="/pages_adex/listar_posts_instagram.php">Listar Posts</a>
          </div>
        </div>
      </div>
    </div>

    <!-- Aulas -->
    <div class="col-12 col-lg-4">
      <div class="card h-100 shadow-sm border-0">
        <div class="card-body">
          <div class="d-flex align-items-center justify-content-between mb-2">
            <h2 class="h5 mb-0">Aulas</h2>
            <span class="badge bg-dark">Conteúdo</span>
          </div>

          <p class="text-muted mb-3" style="max-width: 52ch;">
            Criação, listagem e manutenção das aulas do sistema.
          </p>

          <div class="d-grid gap-2">
            <a class="btn btn-dark" href="/pages_adex/nova_aula.php">Nova Aula</a>
            <a class="btn btn-outline-dark" href="/pages_adex/exibe_aulas.php">Listar Aulas</a>

            <hr class="my-2">

            <a class="btn btn-outline-dark" href="/pages_adex/exibe_aula.php">Exibir Aula (detalhe)</a>
            <a class="btn btn-outline-dark" href="/pages_adex/editar_aula.php">Editar Aula</a>
          </div>
        </div>
      </div>
    </div>

    <!-- Artistas -->
    <div class="col-12 col-lg-4">
      <div class="card h-100 shadow-sm border-0">
        <div class="card-body">
          <div class="d-flex align-items-center justify-content-between mb-2">
            <h2 class="h5 mb-0">Artistas</h2>
            <span class="badge bg-dark">Biografias</span>
          </div>

          <p class="text-muted mb-3" style="max-width: 52ch;">
            Acesso rápido às listagens e edição das fichas de artistas.
          </p>

          <div class="d-grid gap-2">
            <a class="btn btn-dark" href="/pages_adex/listar_artistas.php">Listar Artistas</a>

            <hr class="my-2">

            <a class="btn btn-outline-dark" href="/pages_adex/editar_artista.php">Editar Artista</a>
            
            <hr class="my-2">

            <a class="btn btn-outline-dark" href="/pages_adex/cadastrar_artista.php">Cadastrar Artista</a>            
   
          </div>
        </div>
      </div>
    </div>

  </div>

  <div class="mt-4 text-muted small">
    Dica: use o menu no topo para navegar; estes cards são atalhos.
  </div>

</div>

<?php include_once(__DIR__ . '/includes_adex/footer.php'); ?>
