<?php
// ADEX config (se necessário)
if (!defined('DB_HOST')) {
  include_once(__DIR__ . '/../includes_adex/config.php');
}

// DB do site público
include_once('/home/tomverascom/public_html/artistas-de-blues/includes/db_connect.php');

// Header e menu do ADEX
include_once(__DIR__ . '/../includes_adex/header.php');
include_once(__DIR__ . '/../includes_adex/menu_adex.php');

// Validar ID
$id = isset($_GET['id']) ? (int) $_GET['id'] : 0;
$mensagem = '';
$aula = null;

// Consulta ao banco
if ($id > 0) {
  $stmt = $conn->prepare("SELECT * FROM aulas WHERE id_aulas = ?");
  if ($stmt) {
    $stmt->bind_param("i", $id);
    $stmt->execute();
    $resultado = $stmt->get_result();
    $aula = $resultado->fetch_assoc();
    $stmt->close();

    if (!$aula) {
      $mensagem = '<div class="alert alert-warning">Aula não encontrada.</div>';
    }
  } else {
    $mensagem = '<div class="alert alert-danger">Erro ao preparar consulta.</div>';
  }
} else {
  $mensagem = '<div class="alert alert-warning">ID inválido.</div>';
}
?>

<div class="container my-4">
  <?php if ($mensagem): ?>
    <?= $mensagem ?>
  <?php elseif ($aula): ?>

    <h2 class="mb-3"><?= htmlspecialchars($aula['titulo'] ?? '') ?></h2>

    <?php if (!empty($aula['link_youtube'])): ?>
      <div class="mb-4 ratio ratio-16x9">
        <iframe
          src="<?= htmlspecialchars($aula['link_youtube'] ?? '') ?>"
          title="Vídeo da Aula"
          allowfullscreen>
        </iframe>
      </div>
    <?php endif; ?>

    <?php if (!empty($aula['texto'])): ?>
      <div class="mb-4">
        <h5>Texto da Aula</h5>
        <div><?= nl2br(htmlspecialchars($aula['texto'] ?? '')) ?></div>
      </div>
    <?php endif; ?>

    <ul class="list-group mb-4">

      <?php if (!empty($aula['sequencia'])): ?>
        <li class="list-group-item">
          <strong>Sequência:</strong> <?= htmlspecialchars($aula['sequencia'] ?? '') ?>
        </li>
      <?php endif; ?>

      <?php if (!empty($aula['relacionado_a'])): ?>
        <li class="list-group-item">
          <strong>Relacionado a:</strong> <?= htmlspecialchars($aula['relacionado_a'] ?? '') ?>
        </li>
      <?php endif; ?>

      <?php if (!empty($aula['periodo_inicial']) || !empty($aula['periodo_final'])): ?>
        <li class="list-group-item">
          <strong>Período:</strong>
          <?= htmlspecialchars($aula['periodo_inicial'] ?? '') ?>
          <?php if (!empty($aula['periodo_final'])): ?>
            - <?= htmlspecialchars($aula['periodo_final'] ?? '') ?>
          <?php endif; ?>
        </li>
      <?php endif; ?>

      <?php if (!empty($aula['artistas_relacionados'])): ?>
        <li class="list-group-item">
          <strong>Artistas Relacionados (IDs):</strong>
          <?= htmlspecialchars($aula['artistas_relacionados'] ?? '') ?>
        </li>
      <?php endif; ?>

      <?php if (!empty($aula['bibliografia'])): ?>
        <li class="list-group-item">
          <strong>Bibliografia:</strong>
          <?= nl2br(htmlspecialchars($aula['bibliografia'] ?? '')) ?>
        </li>
      <?php endif; ?>

      <?php if (!empty($aula['fonte'])): ?>
        <li class="list-group-item">
          <strong>Fonte:</strong> <?= htmlspecialchars($aula['fonte'] ?? '') ?>
        </li>
      <?php endif; ?>

      <?php if (!empty($aula['data_criacao'])): ?>
        <li class="list-group-item">
          <strong>Data de Criação:</strong> <?= htmlspecialchars($aula['data_criacao'] ?? '') ?>
        </li>
      <?php endif; ?>

    </ul>

    <a href="editar_aula.php?id=<?= (int) $id ?>" class="btn btn-warning mt-3">
      Editar Aula
    </a>

  <?php endif; ?>
</div>

<?php
include_once(__DIR__ . '/../includes_adex/footer.php');
?>
