<?php
// ADEX config (se necessário)
if (!defined('DB_HOST')) {
  include_once(__DIR__ . '/../includes_adex/config.php');
}

// DB do site público
include_once('/home/tomverascom/public_html/artistas-de-blues/includes/db_connect.php');

// Header e menu do ADEX
include_once(__DIR__ . '/../includes_adex/header.php');
include_once(__DIR__ . '/../includes_adex/menu_adex.php');

// Função para tentar extrair o título do post Instagram pela tag og:title
function obterTituloInstagram($url) {
  $html = @file_get_contents($url);
  if (!$html) {
    return null;
  }

  libxml_use_internal_errors(true);
  $doc = new DOMDocument();
  $doc->loadHTML($html);
  libxml_clear_errors();

  $metas = $doc->getElementsByTagName('meta');
  foreach ($metas as $meta) {
    if ($meta->getAttribute('property') === 'og:title') {
      return $meta->getAttribute('content');
    }
  }
  return null;
}

// Processamento do formulário
$mensagem = '';
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
  $url_instagram = trim($_POST['url_instagram'] ?? '');
  $titulo_miniatura = trim($_POST['titulo_miniatura'] ?? '');
  $artistas_ids = isset($_POST['artistas_ids']) && is_array($_POST['artistas_ids'])
    ? implode(',', $_POST['artistas_ids'])
    : null;

  if ($url_instagram !== '') {
    if ($titulo_miniatura === '') {
      $titulo_miniatura = obterTituloInstagram($url_instagram) ?? '';
    }

    $stmt = $conn->prepare(
      "INSERT INTO posts_instagram
       (url_instagram, titulo_miniatura_insta, artistas_ids, status)
       VALUES (?, ?, ?, 'publicado')"
    );

    if ($stmt) {
      $stmt->bind_param("sss", $url_instagram, $titulo_miniatura, $artistas_ids);
      if ($stmt->execute()) {
        $mensagem = 'Post inserido com sucesso.';
      } else {
        $mensagem = 'Erro ao inserir o post.';
      }
      $stmt->close();
    } else {
      $mensagem = 'Erro ao preparar a inserção.';
    }
  } else {
    $mensagem = 'O campo URL do Instagram é obrigatório.';
  }
}

// Buscar artistas para o select
$artistas = [];
$res = $conn->query("SELECT id_artista, nome_artista FROM artistas ORDER BY nome_artista ASC");
if ($res) {
  while ($row = $res->fetch_assoc()) {
    $artistas[] = $row;
  }
}
?>

<div class="container mt-4 mb-5">
  <h2>Inserir Novo Post do Instagram</h2>

  <?php if ($mensagem): ?>
    <div class="alert alert-info"><?= htmlspecialchars($mensagem ?? '') ?></div>
  <?php endif; ?>

  <form method="post" class="mt-4">

    <div class="mb-3">
      <label for="url_instagram" class="form-label">URL do Post no Instagram *</label>
      <input
        type="url"
        class="form-control"
        id="url_instagram"
        name="url_instagram"
        required
      >
      <div class="form-text">
        URL completa do post (ex: https://www.instagram.com/p/xxxxxxxx/).
      </div>
    </div>

    <div class="mb-3">
      <label for="titulo_miniatura" class="form-label">Título resumido (opcional)</label>
      <input
        type="text"
        class="form-control"
        id="titulo_miniatura"
        name="titulo_miniatura"
        maxlength="255"
      >
      <div class="form-text">
        Texto curto usado como identificação interna do post. Se vazio, o sistema tenta obter o título automaticamente do Instagram.
      </div>
    </div>

    <div class="mb-3">
      <label for="artistas_ids" class="form-label">Artistas Relacionados</label>
      <select
        class="form-select"
        id="artistas_ids"
        name="artistas_ids[]"
        multiple
      >
        <?php foreach ($artistas as $artista): ?>
          <option value="<?= (int) $artista['id_artista'] ?>">
            <?= htmlspecialchars($artista['nome_artista'] ?? '') ?>
          </option>
        <?php endforeach; ?>
      </select>
      <div class="form-text">
        Relaciona o post a um ou mais artistas do banco (uso interno / organização).
      </div>
    </div>

    <button type="submit" class="btn btn-primary">Inserir Post</button>
  </form>
</div>

<?php
include_once(__DIR__ . '/../includes_adex/footer.php');
?>
