<?php
// ADEX config (se necessário)
if (!defined('DB_HOST')) {
  include_once(__DIR__ . '/../includes_adex/config.php');
}

// DB do site público
include_once('/home/tomverascom/public_html/artistas-de-blues/includes/db_connect.php');

// Header e menu do ADEX
include_once(__DIR__ . '/../includes_adex/header.php');
include_once(__DIR__ . '/../includes_adex/menu_adex.php');

// Paginação
$por_pagina = 20;
$pagina = (isset($_GET['pagina']) && is_numeric($_GET['pagina']) && (int)$_GET['pagina'] > 0) ? (int) $_GET['pagina'] : 1;
$inicio = ($pagina - 1) * $por_pagina;

// Total de registros
$total_registros = 0;
$stmtTotal = $conn->prepare("SELECT COUNT(*) as total FROM posts_instagram");
if ($stmtTotal) {
  $stmtTotal->execute();
  $resTotal = $stmtTotal->get_result();
  $rowTotal = $resTotal ? $resTotal->fetch_assoc() : null;
  $total_registros = (int) ($rowTotal['total'] ?? 0);
  $stmtTotal->close();
}
$total_paginas = max(1, (int) ceil($total_registros / $por_pagina));

// Consulta dos posts
$result = null;
$stmt = $conn->prepare("SELECT id_instagram, url_instagram, titulo_miniatura_insta, artistas_ids, status FROM posts_instagram ORDER BY id_instagram DESC LIMIT ? OFFSET ?");
if ($stmt) {
  $stmt->bind_param("ii", $por_pagina, $inicio);
  $stmt->execute();
  $result = $stmt->get_result();
}

// Mapeamento de ID → nome do artista
$mapa_artistas = [];
$res_artistas = $conn->query("SELECT id_artista, nome_artista FROM artistas");
if ($res_artistas) {
  while ($row = $res_artistas->fetch_assoc()) {
    $mapa_artistas[(int)$row['id_artista']] = $row['nome_artista'];
  }
}
?>

<div class="container mt-4 mb-5">
  <h2>Lista de Posts do Instagram</h2>

  <?php if ($result && $result->num_rows > 0): ?>
    <div class="table-responsive mt-4">
      <table class="table table-bordered table-striped align-middle">
        <thead class="table-light">
          <tr>
            <th>ID</th>
            <th>URL</th>
            <th>Título</th>
            <th>Artistas Relacionados</th>
            <th>Status</th>
          </tr>
        </thead>
        <tbody>
          <?php while ($row = $result->fetch_assoc()): ?>
            <?php
              $titulo = htmlspecialchars($row['titulo_miniatura_insta'] ?? '');

              $nomes_artistas = [];
              if (!empty($row['artistas_ids'])) {
                $ids = explode(',', (string)$row['artistas_ids']);
                foreach ($ids as $idArt) {
                  $idArt = (int) trim($idArt);
                  if ($idArt > 0 && isset($mapa_artistas[$idArt])) {
                    $nomes_artistas[] = $mapa_artistas[$idArt];
                  }
                }
              }
            ?>
            <tr>
              <td><?= (int) ($row['id_instagram'] ?? 0) ?></td>
              <td>
                <?php if (!empty($row['url_instagram'])): ?>
                  <a href="<?= htmlspecialchars($row['url_instagram'] ?? '') ?>" target="_blank" rel="noopener">Ver Post</a>
                <?php endif; ?>
              </td>
              <td><?= $titulo ?></td>
              <td><?= htmlspecialchars(implode(', ', $nomes_artistas) ?? '') ?></td>
              <td><?= htmlspecialchars($row['status'] ?? '') ?></td>
            </tr>
          <?php endwhile; ?>
        </tbody>
      </table>
    </div>

    <?php if ($stmt) { $stmt->close(); } ?>

    <?php if ($total_paginas > 1): ?>
      <nav>
        <ul class="pagination justify-content-center mt-4">
          <?php for ($i = 1; $i <= $total_paginas; $i++): ?>
            <li class="page-item <?= ($i === $pagina) ? 'active' : '' ?>">
              <a class="page-link" href="?pagina=<?= (int) $i ?>"><?= (int) $i ?></a>
            </li>
          <?php endfor; ?>
        </ul>
      </nav>
    <?php endif; ?>

  <?php else: ?>
    <p class="mt-4">Nenhum post encontrado.</p>
  <?php endif; ?>
</div>

<?php
include_once(__DIR__ . '/../includes_adex/footer.php');
?>
