<?php
// ADEX config (se necessário)
if (!defined('DB_HOST')) {
  include_once(__DIR__ . '/../includes_adex/config.php');
}

// DB do site público
include_once('/home/tomverascom/public_html/artistas-de-blues/includes/db_connect.php');

// Header e menu do ADEX
include_once(__DIR__ . '/../includes_adex/header.php');
include_once(__DIR__ . '/../includes_adex/menu_adex.php');

$mensagem = '';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
  $sequencia = (isset($_POST['sequencia']) && $_POST['sequencia'] !== '') ? (int) $_POST['sequencia'] : null;

  $titulo = trim($_POST['titulo'] ?? '');
  $texto = trim($_POST['texto'] ?? '');
  $link_youtube = trim($_POST['link_youtube'] ?? '');
  $bibliografia = trim($_POST['bibliografia'] ?? '');
  $fonte = trim($_POST['fonte'] ?? '');

  $periodo_inicial = (isset($_POST['periodo_inicial']) && $_POST['periodo_inicial'] !== '') ? (int) $_POST['periodo_inicial'] : null;
  $periodo_final   = (isset($_POST['periodo_final']) && $_POST['periodo_final'] !== '') ? (int) $_POST['periodo_final'] : null;

  $artistas_relacionados = trim($_POST['artistas_relacionados'] ?? '');

  $relacionado_a = (isset($_POST['relacionado_a']) && is_array($_POST['relacionado_a']))
    ? implode(',', $_POST['relacionado_a'])
    : '';

  if ($titulo !== '') {
    $stmt = $conn->prepare(
      "INSERT INTO aulas
      (sequencia, titulo, texto, link_youtube, bibliografia, fonte, periodo_inicial, periodo_final, artistas_relacionados, relacionado_a)
      VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?)"
    );

    if ($stmt) {
      $stmt->bind_param(
        "isssssiiss",
        $sequencia,
        $titulo,
        $texto,
        $link_youtube,
        $bibliografia,
        $fonte,
        $periodo_inicial,
        $periodo_final,
        $artistas_relacionados,
        $relacionado_a
      );

      if ($stmt->execute()) {
        $mensagem = '<div class="alert alert-success">Aula cadastrada com sucesso!</div>';
      } else {
        $mensagem = '<div class="alert alert-danger">Erro ao salvar.</div>';
      }

      $stmt->close();
    } else {
      $mensagem = '<div class="alert alert-danger">Erro ao preparar inserção.</div>';
    }
  } else {
    $mensagem = '<div class="alert alert-warning">O campo "Título da Aula" é obrigatório.</div>';
  }
}
?>

<div class="container my-4">
  <h2 class="mb-4">Nova Aula</h2>

  <?= $mensagem ?>

  <form method="post" action="<?= htmlspecialchars(basename($_SERVER['PHP_SELF']) ?? '') ?>">
    <div class="mb-3">
      <label for="sequencia" class="form-label">Sequência</label>
      <input type="number" class="form-control" id="sequencia" name="sequencia">
    </div>

    <div class="mb-3">
      <label for="titulo" class="form-label">Título da Aula *</label>
      <input type="text" class="form-control" id="titulo" name="titulo" required>
    </div>

    <div class="mb-3">
      <label for="texto" class="form-label">Texto da Aula</label>
      <textarea class="form-control" id="texto" name="texto" rows="6"></textarea>
    </div>

    <div class="mb-3">
      <label for="link_youtube" class="form-label">Link do YouTube</label>
      <input type="url" class="form-control" id="link_youtube" name="link_youtube">
    </div>

    <div class="mb-3">
      <label for="bibliografia" class="form-label">Bibliografia</label>
      <textarea class="form-control" id="bibliografia" name="bibliografia" rows="4"></textarea>
    </div>

    <div class="mb-3">
      <label for="fonte" class="form-label">Fonte</label>
      <input type="text" class="form-control" id="fonte" name="fonte">
    </div>

    <div class="mb-3">
      <label for="periodo_inicial" class="form-label">Período Inicial (Ano)</label>
      <input type="number" class="form-control" id="periodo_inicial" name="periodo_inicial" min="1000" max="9999">
    </div>

    <div class="mb-3">
      <label for="periodo_final" class="form-label">Período Final (Ano)</label>
      <input type="number" class="form-control" id="periodo_final" name="periodo_final" min="1000" max="9999">
    </div>

    <div class="mb-3">
      <label for="artistas_relacionados" class="form-label">Artistas Relacionados (IDs separados por vírgula)</label>
      <input type="text" class="form-control" id="artistas_relacionados" name="artistas_relacionados" placeholder="Ex: 12,33,45">
    </div>

    <div class="mb-3">
      <label class="form-label">Relacionado a</label>

      <div class="form-check">
        <input class="form-check-input" type="checkbox" name="relacionado_a[]" value="historia" id="historia">
        <label class="form-check-label" for="historia">História</label>
      </div>

      <div class="form-check">
        <input class="form-check-input" type="checkbox" name="relacionado_a[]" value="estoria" id="estoria">
        <label class="form-check-label" for="estoria">Estória</label>
      </div>

      <div class="form-check">
        <input class="form-check-input" type="checkbox" name="relacionado_a[]" value="cultura" id="cultura">
        <label class="form-check-label" for="cultura">Cultura</label>
      </div>

      <div class="form-check">
        <input class="form-check-input" type="checkbox" name="relacionado_a[]" value="epoca" id="epoca">
        <label class="form-check-label" for="epoca">Época</label>
      </div>

      <div class="form-check">
        <input class="form-check-input" type="checkbox" name="relacionado_a[]" value="Trecho de Livro" id="trecho_livro">
        <label class="form-check-label" for="trecho_livro">Trecho Livro</label>
      </div>

      <div class="form-check">
        <input class="form-check-input" type="checkbox" name="relacionado_a[]" value="outros" id="outros">
        <label class="form-check-label" for="outros">Outros</label>
      </div>

    </div>

    <button type="submit" class="btn btn-primary">Salvar Aula</button>
  </form>
</div>

<?php
include_once(__DIR__ . '/../includes_adex/footer.php');
?>
