<?php
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
  header('Location: /');
  exit;
}

// Paths
$includes_path = '/home/tomverascom/public_html/artistas-de-blues/includes/';
$adex_includes = __DIR__ . '/../includes_adex/';

// Config do ADEX (DB_HOST etc)
if (!defined('DB_HOST')) {
  include_once($adex_includes . 'config.php');
}

// DB (usa $conn)
include_once($includes_path . 'db_connect.php');

// Helpers
function post_str(string $key): string {
  return isset($_POST[$key]) ? trim((string)$_POST[$key]) : '';
}

function post_date(string $key): ?string {
  $v = post_str($key);
  if ($v === '') return null; // grava NULL
  if (!preg_match('/^\d{4}-\d{2}-\d{2}$/', $v)) return null;
  return $v;
}

$acao = post_str('acao'); // 'criar' quando vem do cadastrar_artista.php

$id_artista = (int)($_POST['id_artista'] ?? 0);

$nome_artista = post_str('nome_artista');
$url_amigavel = post_str('url_amigavel');
$data_nascimento = post_date('data_nascimento');
$data_falecimento = post_date('data_falecimento');
$url_instagram = post_str('url_instagram');
$url_youtube = post_str('url_youtube');
$url_youtube_shorts = post_str('url_youtube_shorts');
$conteudo = isset($_POST['conteudo']) ? (string)$_POST['conteudo'] : '';
$foto_principal = post_str('foto_principal');
$status = post_str('status');

if ($nome_artista === '' || $url_amigavel === '') {
  echo "Nome e URL amigável são obrigatórios.";
  exit;
}

if (!in_array($status, ['publicado', 'arquivado'], true)) {
  $status = 'publicado';
}

// ------------------------------------------------------------
// MODO CRIAR (INSERT)
// ------------------------------------------------------------
if ($acao === 'criar') {

  // Checa slug duplicado
  $chk = $conn->prepare("SELECT id_artista FROM artistas WHERE url_amigavel = ? LIMIT 1");
  if (!$chk) {
    echo "Erro prepare (check): " . htmlspecialchars($conn->error);
    exit;
  }
  $chk->bind_param("s", $url_amigavel);
  $chk->execute();
  $res = $chk->get_result();

  if ($res && $res->num_rows > 0) {
    // volta pro cadastro com aviso
    header("Location: /pages_adex/cadastrar_artista.php?jaexiste=1");
    exit;
  }

  $sql = "INSERT INTO artistas (
    nome_artista,
    url_amigavel,
    data_nascimento,
    data_falecimento,
    url_instagram,
    url_youtube,
    url_youtube_shorts,
    conteudo,
    foto_principal,
    status
  ) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";

  $stmt = $conn->prepare($sql);
  if (!$stmt) {
    echo "Erro prepare (insert): " . htmlspecialchars($conn->error);
    exit;
  }

  $stmt->bind_param(
    "ssssssssss",
    $nome_artista,
    $url_amigavel,
    $data_nascimento,
    $data_falecimento,
    $url_instagram,
    $url_youtube,
    $url_youtube_shorts,
    $conteudo,
    $foto_principal,
    $status
  );

  if (!$stmt->execute()) {
    echo "Erro ao cadastrar: " . htmlspecialchars($stmt->error);
    exit;
  }

  // Redireciona para edição do novo artista
  header("Location: /pages_adex/editar_artista.php?artista=" . urlencode($url_amigavel) . "&ok=1");
  exit;
}

// ------------------------------------------------------------
// MODO EDITAR (UPDATE)
// ------------------------------------------------------------
if ($id_artista <= 0) {
  echo "ID inválido.";
  exit;
}

$sql = "UPDATE artistas SET
  nome_artista = ?,
  url_amigavel = ?,
  data_nascimento = ?,
  data_falecimento = ?,
  url_instagram = ?,
  url_youtube = ?,
  url_youtube_shorts = ?,
  conteudo = ?,
  foto_principal = ?,
  status = ?
WHERE id_artista = ?
LIMIT 1";

$stmt = $conn->prepare($sql);
if (!$stmt) {
  echo "Erro prepare (update): " . htmlspecialchars($conn->error);
  exit;
}

$stmt->bind_param(
  "ssssssssssi",
  $nome_artista,
  $url_amigavel,
  $data_nascimento,
  $data_falecimento,
  $url_instagram,
  $url_youtube,
  $url_youtube_shorts,
  $conteudo,
  $foto_principal,
  $status,
  $id_artista
);

if (!$stmt->execute()) {
  echo "Erro ao salvar: " . htmlspecialchars($stmt->error);
  exit;
}

header("Location: /pages_adex/editar_artista.php?artista=" . urlencode($url_amigavel) . "&ok=1");
exit;
